//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2
import wesual.Controls 1.0
import wesual.Ui 1.0

Item {
    id : slider

    height : 20
    width : 100

    property real value : 0.5
    property real minimum : 0.0
    property real maximum : 1.0

    property int slideControlWidth : 10
    property int slideControlHeight : 36
    property int slidePathHeight : 4

    property bool  enabled    : true
    property color hoverColor : UI.color(UI.PrimaryHover)

    onValueChanged : {
        if (value < minimum)
            value = minimum;
        else if (value > maximum)
            value = maximum;
    }

    QtObject {
        id : p_

        function computeValue(progress) {
            return Math.max(0.0, Math.min(1.0, progress)) *
                    (maximum - minimum) + minimum;
        }
    }

    Rectangle {
        id : slidePath

        height : slidePathHeight
        width : parent.width
        anchors.verticalCenter : parent.verticalCenter
        color : "#A6A6A6"
        opacity : 1

        Rectangle {
            id : slideColumn

            width : slideControlWidth
            height : slideControlHeight
            color : UiColors.getColor(UiColors.ButtonNormalBlue)
            anchors.verticalCenter : parent.verticalCenter
            x : {
                var newX = (value - minimum) / (maximum - minimum) *
                            parent.width - parseInt(width / 2)

                // slide column should be bound by slide path
                newX = Math.min(newX, (slidePath.width - slideColumn.width));
                newX = Math.max(newX, 0);
            }

            Behavior on color {
                ColorAnimation {
                    duration : 150
                }
            }
        }
    }

    states : [
        State {
            name : "pressed"
            when : sliderMouseArea.pressed
            PropertyChanges {
                target : slidePath
                color  : UI.color(UI.PrimaryPress)
            }
            PropertyChanges {
                target : slideColumn
                color  : UI.color(UI.PrimaryPress)
            }
        },
        State {
            name : "hovered"
            when : sliderMouseArea.containsMouse
            PropertyChanges {
                target : slidePath
                color  : slider.hoverColor
            }
            PropertyChanges {
                target : slideColumn
                color  : slider.hoverColor
            }
        }
    ]

    MouseArea {
        id : sliderMouseArea
        enabled : slider.enabled
        hoverEnabled : enabled
        anchors.fill : parent
        acceptedButtons : Qt.LeftButton
        onPressed : {
            slider.value = p_.computeValue(mouse.x / slider.width);
        }
        onPositionChanged: {
            if (sliderMouseArea.pressed)
                slider.value = p_.computeValue(mouse.x / slider.width);
        }
    }
}
